function CD0tot = build_CD0_total(Mvec, CD0_base, dCD0)
% BUILD_CD0_TOTAL  Crea C_D0,total(M) = C_D0,base(M) + ΔC_D0(M).
% USO:
%   CD0tot = build_CD0_total();                      % defaults
%   CD0tot = build_CD0_total(Mvec, CD0_base, dCD0);  % normal

    if nargin < 1 || isempty(Mvec),     Mvec = (0.78:0.01:0.86)'; end
    if nargin < 2 || isempty(CD0_base), CD0_base = 0.0055;        end
    if nargin < 3 || isempty(dCD0),     dCD0 = 0.0;               end

    Mvec = Mvec(:);
    CD0b = eval_CD0(Mvec, CD0_base);
    dC   = eval_CD0(Mvec, dCD0);

    CD0tot.M = Mvec;
    CD0tot.CD0 = CD0b + dC;
end



% ============================================================
%   AIRCRAFT PERFORMANCE & DESIGN – PIPELINE ASIGNACIONES 1–4
% ============================================================
%
% 🔹 Propósito
% Este conjunto de funciones automatiza los cálculos de 
% performance (Asignaciones 1–4), permitiendo trabajar tanto
% con CD0 base constante como con la curva ΔCD0(M) digitalizada.
% Los módulos están diseñados para ejecutarse en cadena y 
% generar tablas, gráficas y resúmenes con explicación.
%
% 🔹 Flujo de ejecución principal (pipeline)
%
% run_airperf.m
%   └─> isa_std_atmos     → atm
%   └─> base_quantities   → base
%   └─> build_CD0_total   → CD0tot
%   └─> build_drag_table  → T
%   └─> check_mach_cap    → cap
%   └─> breguet_ER        → breg
%   └─> describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%
% 🔹 Descripción de cada módulo
%
% isa_std_atmos(h_ft)
%   ENTRADA: altitud [ft]
%   SALIDA : atm struct con:
%       T_K, T_R, a_fts, rho, sigma
%   → Modelo de atmósfera estándar (ISA).
%
% base_quantities(atm, inputs)
%   ENTRADA: atm, struct inputs con {S, W, AR, e, TSFC, T_SL_tot}
%   SALIDA : base struct con:
%       q0, q0S, k, TSFC corregido
%   → Calcula magnitudes base aerodinámicas.
%
% build_CD0_total(M_grid, CD0_base, dCD0)
%   ENTRADA: malla Mach, CD0_base, curva ΔCD0(M)
%   SALIDA : CD0tot vector
%   → Construye la curva de arrastre parasitario.
%     (dos caminos: CD0_base constante o digitalización ΔCD0).
%
% build_drag_table(M_grid, CD0tot, base, inputs)
%   ENTRADA: Mach grid, CD0tot, base, inputs
%   SALIDA : tabla T con columnas:
%       M, C_D0, C_D, C_L, D_par, D_ind, D_tot
%   → Calcula arrastres parasitario, inducido y total.
%
% check_mach_cap(M_cap, CD0tot, base, inputs)
%   ENTRADA: Mach operativo
%   SALIDA : cap struct con:
%       C_D_cap, D_cap, T_avail
%   → Compara empuje disponible vs arrastre.
%     Determina si gobierna Mach límite o empuje.
%
% breguet_ER(inputs, base, atm)
%   ENTRADA: TSFC, (L/D), Wi/Wf, Mach operativo
%   SALIDA : breg struct con:
%       E (endurance), R (range)
%   → Implementa ecuaciones de Breguet.
%
% describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%   ENTRADA: todos los structs anteriores
%   SALIDA : impresión en consola con unidades y explicación
%   → Resume y documenta resultados.
%
% 🔹 Notas de uso
% - Siempre arrancar desde run_airperf.m
% - Cada módulo puede probarse aislado llamando con sus argumentos.
% - Diseñado para Matlab Online con entrada/salida clara y
%   documentada para reportes técnicos en LaTeX.
%
% ============================================================
